#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    long long x, y;
    int index;
} Vektor;

typedef struct {
    long long dist_sq;
    int k;
    int *indeksi;
} Rezultat;

void oslobodi_rezultat(Rezultat *r) {
    if (r->indeksi != NULL) {
        free(r->indeksi);
    }
}

Rezultat Izracunaj(int N, Vektor vektori[], int (*predikat)(long long, long long)) {
    Rezultat rez;
    rez.dist_sq = 0;
    rez.k = 0;
    rez.indeksi = NULL;

    long long Rx = 0;
    long long Ry = 0;
    int *trenutni_indeksi = (int *)malloc(N * sizeof(int));
    if (trenutni_indeksi == NULL) return rez;

    int trenutni_k = 0;
    
    for (int i = 0; i < N; i++) {
        long long xi = vektori[i].x;
        long long yi = vektori[i].y;

        if (predikat(xi, yi)) {
            Rx += xi;
            Ry += yi;
            trenutni_indeksi[trenutni_k++] = vektori[i].index;
        }
    }

    rez.dist_sq = Rx * Rx + Ry * Ry;
    rez.k = trenutni_k;
    
    if (trenutni_k > 0) {
        rez.indeksi = (int *)malloc(trenutni_k * sizeof(int));
        if (rez.indeksi != NULL) {
            for(int i = 0; i < trenutni_k; i++) {
                rez.indeksi[i] = trenutni_indeksi[i];
            }
        } else {
             rez.k = 0;
        }
    }
    
    free(trenutni_indeksi);
    return rez;
}

int predikat_x(long long x, long long y) { return x > 0; }
int predikat_y(long long x, long long y) { return y > 0; }
int predikat_sum(long long x, long long y) { return x + y > 0; }
int predikat_raz(long long x, long long y) { return x - y > 0; }

int main() {
    int N;
    if (scanf("%d", &N) != 1) return 1;

    Vektor vektori[N];
    for (int i = 0; i < N; i++) {
        if (scanf("%lld %lld", &vektori[i].x, &vektori[i].y) != 2) return 1;
        vektori[i].index = i + 1;
    }

    Rezultat rezultati[4];
    Rezultat najbolji_rez = {0, 0, NULL};

    rezultati[0] = Izracunaj(N, vektori, predikat_x);
    if (rezultati[0].dist_sq > najbolji_rez.dist_sq) {
        oslobodi_rezultat(&najbolji_rez);
        najbolji_rez = rezultati[0];
    } else {
        oslobodi_rezultat(&rezultati[0]);
    }
    
    rezultati[1] = Izracunaj(N, vektori, predikat_y);
    if (rezultati[1].dist_sq > najbolji_rez.dist_sq) {
        oslobodi_rezultat(&najbolji_rez);
        najbolji_rez = rezultati[1];
    } else {
        oslobodi_rezultat(&rezultati[1]);
    }

    rezultati[2] = Izracunaj(N, vektori, predikat_sum);
    if (rezultati[2].dist_sq > najbolji_rez.dist_sq) {
        oslobodi_rezultat(&najbolji_rez);
        najbolji_rez = rezultati[2];
    } else {
        oslobodi_rezultat(&rezultati[2]);
    }

    rezultati[3] = Izracunaj(N, vektori, predikat_raz);
    if (rezultati[3].dist_sq > najbolji_rez.dist_sq) {
        oslobodi_rezultat(&najbolji_rez);
        najbolji_rez = rezultati[3];
    } else {
        oslobodi_rezultat(&rezultati[3]);
    }

    printf("%d\n", najbolji_rez.k);
    if (najbolji_rez.k > 0) {
        for (int i = 0; i < najbolji_rez.k; i++) {
            printf("%d%s", najbolji_rez.indeksi[i], (i == najbolji_rez.k - 1) ? "" : " ");
        }
        printf("\n");
    } else {
         printf("\n");
    }

    oslobodi_rezultat(&najbolji_rez);

    return 0;
}